<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class PostCollectionCreatePostCollectionTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('post_collections', function (Blueprint $table): void {
            $table->id();
            $table->string('name', 255);
            $table->string('description', 400)->nullable();
            $table->string('image', 255)->nullable();
            $table->string('status', 60)->default('published');
            $table->timestamps();
        });

        Schema::create('post_collections_posts', function (Blueprint $table): void {
            $table->id();
            $table->integer('post_collection_id')->unsigned()->references('id')->on('post_collections')->onDelete('cascade');
            $table->integer('post_id')->unsigned()->references('id')->on('posts')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('post_collections');
        Schema::dropIfExists('post_collections_posts');
    }
}
