@extends('plugins/member::themes.dashboard.layouts.master')

@section('content')
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-6">
                <div class="card login-form">
                    <div class="card-body">
                        <h4 class="text-center">{{ trans('plugins/member::dashboard.login-title') }}</h4>
                        <br>
                        <form
                            method="POST"
                            action="{{ route('public.member.login') }}"
                        >
                            @csrf
                            <div class="mb-3">
                                <input
                                    id="email"
                                    type="email"
                                    class="form-control{{ $errors->has('email') ? ' is-invalid' : '' }}"
                                    placeholder="{{ trans('plugins/member::dashboard.email') }}"
                                    name="email"
                                    value="{{ old('email') }}"
                                    autofocus
                                >
                                @if ($errors->has('email'))
                                    <span class="invalid-feedback">
                                        <strong>{{ $errors->first('email') }}</strong>
                                    </span>
                                @endif
                            </div>
                            <div class="mb-3">
                                <input
                                    id="password"
                                    type="password"
                                    class="form-control{{ $errors->has('password') ? ' is-invalid' : '' }}"
                                    placeholder="{{ trans('plugins/member::dashboard.password') }}"
                                    name="password"
                                >
                                @if ($errors->has('password'))
                                    <span class="invalid-feedback">
                                        <strong>{{ $errors->first('password') }}</strong>
                                    </span>
                                @endif
                            </div>
                            <div class="mb-3">
                                <div class="checkbox">
                                    <label>
                                        <input
                                            type="checkbox"
                                            name="remember"
                                            {{ old('remember') ? 'checked' : '' }}
                                        > {{ trans('plugins/member::dashboard.remember-me') }}
                                    </label>
                                </div>
                            </div>
                            <div class="mb-0 form-group">
                                <button
                                    type="submit"
                                    class="btn btn-blue btn-full fw6"
                                >
                                    {{ trans('plugins/member::dashboard.login-cta') }}
                                </button>
                                <div class="text-center">
                                    <a
                                        class="btn btn-link"
                                        href="{{ route('public.member.password.request') }}"
                                    >
                                        {{ trans('plugins/member::dashboard.forgot-password-cta') }}
                                    </a>
                                </div>
                            </div>

                            <div class="text-center">
                                {!! apply_filters(BASE_FILTER_AFTER_LOGIN_OR_REGISTER_FORM, null, Botble\Member\Models\Member::class) !!}
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@push('scripts')
    {!! JsValidator::formRequest(Botble\Member\Http\Requests\LoginRequest::class) !!}
@endpush
